// Copyright 2006 Adobe Macromedia Software LLC and its licensors. All rights reserved.
//
// Implements the Active Content extension for Generic ActiveX Objects.

//----------------------------------------------------------------------------
// generateFunctionName()
//
// returns the name of the function that will be inserted into the page
//----------------------------------------------------------------------------
function generateFunctionName()
{
   return g_activexConverter.generateFunctionName();
}

//----------------------------------------------------------------------------
// supportedTags()
//
// Returns an object with the following properties describing this converter:
//    obj.supportsAppletTag           (bool)
//    obj.supportedObjectTagClassIDs  (array of strings)
//    obj.supportedMimeTypes          (array of strings)
//    obj.supportedEmbedTagExtensions (array of strings)
//----------------------------------------------------------------------------
function supportedTags()
{
  return g_activexConverter;
}

//----------------------------------------------------------------------------
// getIncludeFiles()
//
// Returns an array which is a list of .js files that must be:
//   (a) inserted into the HEAD of the user's HTML document in the form
//       <script src="filename.js"></script>, and
//   (b) added to the user's site.
//----------------------------------------------------------------------------
function getIncludeFiles()
{
  return [ "AC_ActiveX.js", "AC_RunActiveContent.js" ];
}

//----------------------------------------------------------------------------
// Constructor
//----------------------------------------------------------------------------
function ActiveXActiveContent()
{
  //call the base class constructor
  ActiveXActiveContent.prototype.constructor();

  // properties used by the caller of supportedTags():
  this.supportedObjectTagClassIDs = [  ]; // Empty for Generic ActiveX object
  this.supportedMimeTypes = [  ]; // Empty for Generic ActiveX object
  this.supportedEmbedTagExtensions = [  ]; // Empty for Generic ActiveX object
}

// specify base class
ActiveXActiveContent.prototype = new ActiveContent();

//ActiveXActiveContent.prototype.generateScript = ActiveXActiveContent_generateScript;

var g_activexConverter = new ActiveXActiveContent(); // singleton

//----------------------------------------------------------------------------
// generateScript()
//
// Given an <object> or <embed> or <applet> tag, this converts it into a
// <script> tag.
//----------------------------------------------------------------------------
function generateScript(node)
{
  // have the singleton do the work
  return g_activexConverter.generateScript(node);
}

//----------------------------------------------------------------------------
// canConvert()
//
// returns whether this node can be converted
// Given an <object> tag, this returns if the contents of this tag are
// convertible.  The criteria is that only <param> and <embed> tags exist.
// If any other content exists, return FALSE
//----------------------------------------------------------------------------
function canConvert(node)
{
	return g_activexConverter.objectTagHasOnlyParamAndEmbed(node);
}


//----------------------------------------------------------------------------
// ActiveXActiveContent.processAttributes
//
// Process the list of object/param/embed tags.
//
// Since this ActiveContent converter handles both Flash and Shockwave, we
// examine the attributes in order to determine which one is needed.
//
// We also make necessary changes to the list of attributes, such as
// removing filename extensions and GUIDs.
//----------------------------------------------------------------------------
ActiveXActiveContent.prototype.processAttributes = function(attrs)
{
  // assign two-letter code: Generic ActiveX object (AX)
  this.twoLetterCode = 'AX';
  
  ActiveContent.prototype.processAttributes(attrs);
}

ActiveXActiveContent.prototype.getTwoLetterCode = function()
{
  return this.twoLetterCode;
}
